<?xml version="1.0" encoding="UTF-8" ?>



<!--

    Document   : tree.xsl

    Created on : October 8, 2003, 10:15 AM

    Author     : andrew

    Description:

        Purpose of transformation follows.

-->



<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html"/>



<!--	<xsl:param name='tagName' select="'source'"/> -->

		

	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>

	

	<xsl:template match="/">

		<table class='tree' border="0" cellpadding="0" cellspacing="0">

			<xsl:apply-templates/>

		</table>

	</xsl:template>

	

	<xsl:template match='node()[name() = "source"]'>

		<tr id='{@id}' treeLevel='{count(ancestor::*[name()="source"])}'>

			<td title='{@name}' nowrap=''>

				<span class='treeIndent'>

					<xsl:for-each select='ancestor::*[name() = "source" and parent::*[name() = "source"]]'>

						<xsl:variable name='treeNextTreeNode' select='following-sibling::*[name()="source"]'/>

						<span><xsl:attribute name='class'>AncestorL<xsl:if test='$treeNextTreeNode'>2</xsl:if></xsl:attribute>&#160;</span>

						<span><xsl:attribute name='class'>AncestorR<xsl:if test='$treeNextTreeNode'>2</xsl:if></xsl:attribute>&#160;</span>

					</xsl:for-each>

					<xsl:if test='parent::*[name() = "source"]'>

						<span><xsl:attribute name='class'>ParentL<xsl:if test='following-sibling::*[name()="source"]'>2</xsl:if></xsl:attribute>&#160;</span>

						<span class='parentR'>&#160;</span>

					</xsl:if>

					<xsl:if test='*[name()="source"]'>

						<b class='Opened' onclick='_tree.toggle()'>&#160;</b>

					</xsl:if>

					<span><xsl:attribute name='class'>Space<xsl:if test='node()[name()="source"]'>2</xsl:if></xsl:attribute>&#160;</span>

				</span><span style='float:left'><xsl:value-of select='@name'/></span>

			</td>

		</tr>

		<xsl:apply-templates/>

	</xsl:template>

<!--

    <xsl:template match="/">

        <html>

            <head>

                <title>tree.xsl</title>

                <LINK href='tree.css' type="text/css" REL="STYLESHEET"/>

				<script src="tree.js">//</script>

            </head>

            <body>

                <table border="0" cellpadding="0" cellspacing="0" style='width:100%;'>

                <xsl:apply-templates/>

                </table>

            </body>

        </html>

    </xsl:template>



-->

</xsl:stylesheet>

